TITLE   'Steady Heat Conduction, 2 cylinders, up-down'			                  { exa357b.pde }
SELECT     errlim=1e-3     ngrid=1     spectral_colors
COORDINATES   cartesian3
VARIABLES   temp
DEFINITIONS
   L=0.1     r0=0.015     z0=0.02
   k     heat=0             		{ Thermal conductivity and power density }
   in_fluxd=1e6
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_x, fluxd_y, fluxd_z)     fluxdm=magnitude( fluxd)
EQUATIONS
   div( fluxd)=heat
EXTRUSION						{ Parallel surfaces }
   surface 'bottom' z=-L
   layer 'copper_'
   surface 'CuFe' z=0	
   layer 'iron'	 					
   surface 'FeCu' z=z0					{ Interface }
   layer 'copper'						
   surface 'top' z=L
BOUNDARIES
region 'domain'    					{ Full solution domain }	
   layer 'copper_' void
   layer 'iron'    k=82					{ Thermal conductivity }
   layer 'copper'  void
   start 'outer' (0,0)   natural( temp)=0
      line to (L,0)  line to (L,L)  to (0,L)  to finish
region 'cylinder'						{ Redefine void }
   layer 'copper_' void
   surface 'top'  value( temp)=300		
   layer 'iron'    k=82					{ Thermal conductivity }
   layer 'copper'   k=400
   start (L/4+r0,L/4)
      arc( center=L/4,L/4) angle=360 to finish
region 'cylinder_'						{ Redefine void }	
   layer 'copper_' k=82
   surface 'bottom'  value( temp)=400	
   layer 'iron'    k=82					{ Thermal conductivity }
   layer 'copper' void
   start (3*L/4+r0,3*L/4)
      arc( center=3*L/4,3*L/4) angle=360 to finish
PLOTS
   grid( x,y,z)
   contour( temp) on x=y     contour( fluxdm ) painted on x=y
   vector( fluxd) norm on x=y
   contour( temp) on y=0     contour( temp) on y=L/4
   contour( temp) on x=L/4
   contour( temp) on z=z0 on 'iron'    contour( temp) on z=0
   contour( normal( fluxd)) painted on z=z0
END

